/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.admin.result;

import filenet.vw.api.VWException;
import filenet.vw.api.VWRoster;
import filenet.vw.api.VWRosterDefinition;
import filenet.vw.api.VWRosterQuery;
import filenet.vw.api.VWWorkObject;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.admin.result.VWAdminResultPane;
import filenet.vw.toolkit.admin.result.VWAdminWFByWOInRosterTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWOTableModel;
import filenet.vw.toolkit.admin.result.VWAdminWorkObjectTableData;
import filenet.vw.toolkit.admin.search.VWAdminPerformSearchEvent;

public abstract class VWAdminWOInRosterTableModel
extends VWAdminWOTableModel {
    protected VWRoster m_vwRoster = null;
    protected VWWorkObject m_curRosterWorkObject = null;
    protected VWRosterQuery m_vwRosterQuery = null;
    protected String m_rosterName = null;

    public VWAdminWOInRosterTableModel(VWAdminResultPane resultsPane, VWAdminPerformSearchEvent event) {
        super(resultsPane, event);
        try {
            this.m_rosterName = event.getSelectedItem();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    protected void startTheQuery() throws Exception {
        this.setQueryFlags(this.m_queryFlags);
        this.setQueryFetchType(1);
        this.m_vwRoster = this.m_vwSession.getRoster(this.m_rosterName);
        this.m_vwRoster.setBufferSize(this.m_maxReturned);
        this.m_vwRosterQuery = this.m_vwRoster.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
        this.getExposedFieldsDefinition();
        this.initColumnsOrder();
    }

    protected int fetchQueryCount() throws Exception {
        int count = -1;
        try {
            this.setQueryFlags(this.m_queryFlags);
            this.setQueryFetchType(1);
            this.m_vwRoster = this.m_vwSession.getRoster(this.m_rosterName);
            this.m_vwRoster.setBufferSize(this.m_maxReturned);
            this.m_vwRosterQuery = this.m_vwRoster.createQuery(this.m_queryIndexName, this.m_queryMinIndexValue, this.m_queryMaxIndexValue, this.m_queryFlags, this.m_queryFilter, this.m_querySubstitutionVars, this.m_queryFetchType);
            count = this.m_vwRosterQuery.fetchCount();
        }
        catch (Exception ex) {
            count = -1;
            throw ex;
        }
        return count;
    }

    protected void retrieveWorkObjects() throws Exception {
        VWWorkObject curWorkObject = null;
        int rowNum = 0;
        try {
            if (this.m_objectCache != null) {
                this.m_objectCache.removeAllElements();
            }
            for (rowNum = 0; rowNum < this.m_maxReturned && (curWorkObject = (VWWorkObject)this.m_vwRosterQuery.next()) != null; ++rowNum) {
                VWAdminWorkObjectTableData dataField = this instanceof VWAdminWFByWOInRosterTableModel ? new VWAdminWorkObjectTableData(curWorkObject, this.m_logonUser, true, rowNum + 1, rowNum) : new VWAdminWorkObjectTableData(curWorkObject, this.m_logonUser, false, rowNum + 1, rowNum);
                this.m_objectCache.addElement(dataField);
            }
            if (rowNum > 0) {
                ++this.m_setNum;
            }
            if (this.m_vwRosterQuery.hasNext()) {
                this.setHasNext(true);
            } else {
                this.setHasNext(false);
            }
        }
        catch (OutOfMemoryError err) {
            throw new VWException("vw.toolkit.admin.result.outOfMemoryError", "Out of memory.  Please use a smaller maximum returned set.");
        }
        catch (Exception ex) {
            throw ex;
        }
    }

    protected void getExposedFieldsDefinition() {
        VWRosterDefinition vwRosterDefinition = null;
        try {
            vwRosterDefinition = this.m_vwRoster.fetchRosterDefinition();
            this.m_vwFieldDefinitions = vwRosterDefinition == null ? null : vwRosterDefinition.getFields();
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }
}

